<?php

set_time_limit(0);

include("config.inc.php");

$template = "html";


function startElement($parser, $name, $attrs)
{
 GLOBAL $tags, $current_open_tag, $qp_system_variables_tagname, $qp_user_variables_tagname, $qp_document_tagname;
 $current_open_tag = $name;
 if ($name == $qp_document_tagname)
 {
  while (list ($key, $val) = each ($attrs))
  {
   $tags[$key] = $val;
  }
 }
 if ($name == $qp_system_variables_tagname)
 {
  while (list ($key, $val) = each ($attrs))
  {
   $tags[$key] = $val;
  }
 }
 if ($name == $qp_user_variables_tagname)
 {
  while (list ($key, $val) = each ($attrs))
  {
   $tags[$key] = $val;
  }
 }
}

function endElement($parser, $name)
{
 GLOBAL $current_open_tag;
 $current_open_tag = "";
}


$fp = fopen($qp_template_dir."/".$template."/structure.qsf", "r");
$structure = fread($fp, filesize($qp_template_dir."/".$template."/structure.qsf"));
fclose($fp);
$fp = fopen($qp_template_dir."/".$template."/stylesheet.qss", "r");
$stylesheet = fread($fp, filesize($qp_template_dir."/".$template."/stylesheet.qss"));
fclose($fp);
$fp = fopen($qp_template_dir."/".$template."/config.qcf", "r");
$config = fread($fp, filesize($qp_template_dir."/".$template."/config.qcf"));
fclose($fp);

ereg("<targetroot>(.*)</targetroot>", $config, $a);
$targetroot = $a[1];
ereg("<previewroot>(.*)</previewroot>", $config, $a);
$previewroot = $a[1];
ereg("<targetsuffix>(.*)</targetsuffix>", $config, $a);
$targetsuffix = $a[1];

$files = recurse_dir($qp_input_dir, 1);

reset ($files);
while (list ($key, $val) = each ($files))
{
 $filename_s = basename($val);
 $dirname_s = dirname($val);
 $dirname_t = ereg_replace($qp_input_dir, $qp_output_dir."/".$previewroot, $dirname_s);
 $depths = explode("/", $val);
 $depth = count($depths) - 2;
 $tags["rootpath_relative"] = "";
 for($i = 1; $i < $depth; $i++)
 {
  $tags["rootpath_relative"] .= "../";
 }  
 if(!is_dir($dirname_t))
 {
  force_dir($dirname_t);
 }
 if (substr($val, -4) <> ".xml")
 {
  copy($val, $dirname_t."/".$filename_s);
  //echo "<b>c:</b> ".$dirname_t."/".$filename_s."<br>";
 }
 else
 {
  $xml_parser = xml_parser_create();
  xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, false);
  xml_parser_set_option($xml_parser, XML_OPTION_SKIP_WHITE, 1);
  xml_set_element_handler($xml_parser, "startElement", "endElement");
  $fp = fopen($val, "r");
  $data = fread($fp, filesize($val));
  ereg("<".$qp_content_tagname.">(.*)</".$qp_content_tagname.">", $data, $a);
  $tags[$qp_content_tagname] = $a[1];
  $data = ereg_replace("<".$qp_content_tagname.">(.*)</".$qp_content_tagname.">", "", $data);
  if (!xml_parse($xml_parser, $data))
  {
   die(sprintf("XML error: %s in file $val at line %d",
   xml_error_string(xml_get_error_code($xml_parser)),
   xml_get_current_line_number($xml_parser)));
  }
  xml_parser_free($xml_parser);
  fclose($fp);
  $old_structure = $structure;
  reset($tags);
  while (list ($keyt, $valt) = each ($tags))
  {
   $structure = ereg_replace("\{".$keyt."\}", $valt, $structure);
  }
  // 2 times coz some vals might also contain {place_holders}
  reset($tags);
  while (list ($keyt, $valt) = each ($tags))
  {
   $structure = ereg_replace("\{".$keyt."\}", $valt, $structure);
  }
  if ($tags["required_suffix"] <> "")
  {
   $filename_t = ereg_replace(".xml", ".".$tags["required_suffix"], $filename_s);
  }
  else
  {
   $filename_t = ereg_replace(".xml", ".".$targetsuffix, $filename_s);
  }
  $structure = ereg_replace("<a href=\"(.*).xml\"", "<a href=\"\\1.".$targetsuffix."\"", $structure);
  $fp = fopen($dirname_t."/".$filename_t, "w");
  fputs($fp, $structure);
  fclose($fp);
  $linktext = "&lt;a href=\"".ereg_replace($qp_output_dir."/".$previewroot, "", $dirname_t)."/".$filename_t."\"&gt;".$tags["title"]."&lt;/a&gt;&lt;br&gt;<br>";
  echo ereg_replace("href=\"/", "href=\"", $linktext);
  $structure = $old_structure;
 }
}

?>

<form action="copyparsed.php" method="post">
<input type="hidden" name="sourceroot" value="<?php echo $qp_output_dir."/".$previewroot; ?>">
<input type="hidden" name="targetroot" value="<?php echo $targetroot; ?>">
<input type="submit" value="Copy into system">
</form>