<?php

$qp_userdata_dir = "userdata";
$qp_input_dir = $qp_userdata_dir."/input";
$qp_output_dir = $qp_userdata_dir."/output";
$qp_template_dir = $qp_userdata_dir."/templates";

$qp_document_tagname = "qp_document";
$qp_system_variables_tagname = "qp_system_variables";
$qp_user_variables_tagname = "qp_user_variables";
$qp_content_tagname = "qp_content";

$qp_editor_name = "Your name here";
$qp_editor_mail = "Your mail here";



// Functions
function display_perms($mode) 
{ 
 // thanks to pwalker@pwccanada.com
 /* Determine Type */ 
 if(($mode & 0xC000) === 0xC000) // Unix domain socket 
 $type = 's'; 
 elseif(($mode & 0x4000) === 0x4000) // Directory 
 $type = 'd'; 
 elseif(($mode & 0xA000) === 0xA000) // Symbolic link 
 $type = 'l'; 
 elseif(($mode & 0x8000) === 0x8000) // Regular file 
 $type = '-'; 
 elseif(($mode & 0x6000) === 0x6000) // Block special file 
 $type = 'b'; 
 elseif(($mode & 0x2000) === 0x2000) // Character special file 
 $type = 'c'; 
 elseif(($mode & 0x1000) === 0x1000) // Named pipe 
 $type = 'p'; 
 else // Unknown 
 $type = '?';
 
 /* Determine permissions */ 
 $owner["read"] = ($mode & 00400) ? 'r' : '-'; 
 $owner["write"] = ($mode & 00200) ? 'w' : '-'; 
 $owner["execute"] = ($mode & 00100) ? 'x' : '-'; 
 $group["read"] = ($mode & 00040) ? 'r' : '-'; 
 $group["write"] = ($mode & 00020) ? 'w' : '-'; 
 $group["execute"] = ($mode & 00010) ? 'x' : '-'; 
 $world["read"] = ($mode & 00004) ? 'r' : '-'; 
 $world["write"] = ($mode & 00002) ? 'w' : '-'; 
 $world["execute"] = ($mode & 00001) ? 'x' : '-'; 
 
 /* Adjust for SUID, SGID and sticky bit */ 
 if( $mode & 0x800 ) 
 $owner["execute"] = ($owner[execute]=='x') ? 's' : 'S'; 
 if( $mode & 0x400 ) 
 $group["execute"] = ($group[execute]=='x') ? 's' : 'S'; 
 if( $mode & 0x200 ) 
 $world["execute"] = ($world[execute]=='x') ? 't' : 'T'; 
 
 return $permstring = $type.$owner[read].$owner[write].$owner[execute].$group[read].$group[write].$group[execute].$world[read].$world[write].$world[execute]; 
} 


// this function returns all files in the passed directory - it's recursive when you set $recursive = 1
function recurse_dir($dirname, $recursive)
{ 
 // tahnks to eric@themepark.com
 // try to figure out what delimeter is that's already in use... 
 $delim = (strstr($dirname,"/")) ? "/" : "\\"; 
 if($dirname[strlen($dirname)-1]!=$delim)
 {
  $dirname .= $delim;
 }

 $handle = opendir($dirname); 

 while ($file = readdir($handle))
 {
  if($file=='.'||$file=='..')
  {
   continue;
  }
  if(is_dir($dirname.$file) && $recursive)
  {
   $x = recurse_dir($dirname.$file.$delim, 1);
   $result_array = array_merge($result_array, $x);
  }
  else
  {
   $result_array[]=$dirname.$file;
  }
 }
 closedir($handle);
 if (sizeof($result_array))
 { 
  natsort($result_array); 
 } 
 return $result_array; 
}



function force_dir($path)
{ 
 if (strlen($path) == 0)
 {
  return 0; 
 } 
 elseif (is_dir($path))
 { 
  return 1; // avoid 'xyz:\' problem.
 } 
 elseif (dirname($path) == $path)
 { 
  return 1; // avoid 'xyz:\' problem. 
 }
 return (force_dir(dirname($path)) AND mkdir($path, 0755)); 
}


function analysedir($dirline) 
{ 
 global $systyp,$ftp_server,$stop; 

 if(ereg("([-dl])[rwxst-]{9}",substr($dirline,0,10)))
 { 
  $systyp = "UNIX";
 } 

 if(substr($dirline,0,5) == "total")
 { 
  $dirinfo[0] = -1; 
 }
 elseif($systyp=="Windows_NT")
 { 
  if(ereg("[-0-9]+ *[0-9:]+[PA]?M? +<DIR> {10}(.*)",$dirline,$regs))
  { 
   $dirinfo[0] = 1; 
   $dirinfo[1] = 0; 
   $dirinfo[2] = $regs[1]; 
  }
  elseif(ereg("[-0-9]+ *[0-9:]+[PA]?M? +([0-9]+) (.*)",$dirline,$regs))
  { 
   $dirinfo[0] = 0; 
   $dirinfo[1] = $regs[1]; 
   $dirinfo[2] = $regs[2]; 
  } 
 }
 elseif($systyp=="UNIX")
 { 
  if(ereg("([-d])[rwxst-]{9}.* ([0-9]*) [a-zA-Z]+ [0-9: ]*[0-9] (.+)",$dirline,$regs))
  { 
   if($regs[1]=="d") $dirinfo[0] = 1; 
   $dirinfo[1] = $regs[2]; 
   $dirinfo[2] = $regs[3]; 
  } 
 }

 if(($dirinfo[2]==".")||($dirinfo[2]=="..")) $dirinfo[0]=0; 

 // array -> 0 = switch, directory or not 
 // array -> 1 = filesize (if dir =0) 
 // array -> 2 = filename or dirname 

 return $dirinfo; 
} 



?>
